unit uAddVendorInvoice;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, DB, ADODB, Grids, DBGridEh,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, GridsEh,
  DBAxisGridsEh, DateUtils, System.UITypes, EhLibVCL, Vcl.ExtCtrls;

type
  TfrmAddVendorInvoice = class(TForm)
    UNP: TEdit;
    NumberESCF: TEdit;
    CheckUNNPredprNameLbl: TLabel;
    DateTimePicker1: TDateTimePicker;
    YearCB: TComboBox;
    UNNLbl: TLabel;
    YearLbl: TLabel;
    NumberLbl: TLabel;
    DateLbl: TLabel;
    CheckUnnBtn: TBitBtn;
    PredprSelQ: TADOQuery;
    UpdateVendor: TADOQuery;
    UpdateInvoice: TADOQuery;
    SearchOriginal: TADOQuery;
    OriginalsDBGridEh: TDBGridEh;
    SearchOriginalDS: TDataSource;
    SearchDatePicker2: TDateTimePicker;
    SearchDatePicker1: TDateTimePicker;
    SearchGB: TGroupBox;
    TNNSearchGB: TGroupBox;
    TTNNumber: TEdit;
    TTNDateTimePicker: TDateTimePicker;
    Label6: TLabel;
    Label7: TLabel;
    SearchCheckBox1: TCheckBox;
    SearchOriginaldocDate: TDateTimeField;
    SearchOriginalnumber: TLargeintField;
    SearchOriginaltotalCost: TBCDField;
    SearchOriginaltotalVat: TBCDField;
    SearchOriginaltotalCostVat: TBCDField;
    SearchOriginalnamePredpr: TStringField;
    SaveBtn: TButton;
    CancelBtn: TButton;
    DelBtn: TButton;
    RefreshBtn: TButton;
    SetBtn: TButton;
    TopPanel: TPanel;
    BottomPanel: TPanel;
    procedure CheckUnnBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure SearchCheckBox1Click(Sender: TObject);
    procedure SetBtnClick(Sender: TObject);
  private
    { Private declarations }
    idSender: Integer;
    compilingYear: Integer;
    number: Int64;
    documentType: Byte;
    idRecipient: Integer;
    procedure UpdateVendorProc(Table: string; Del: Boolean);
    procedure UpdateInvoiceProc(Table: string);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; idSender, compilingYear, idRecipient:
      Integer; number: Int64; fullvendor, invoice: string; vendordate: TDateTime;
      documentType: Byte); reintroduce;
  end;

var
  frmAddVendorInvoice: TfrmAddVendorInvoice;

implementation

uses
  uDM;

{$R *.dfm}

constructor TfrmAddVendorInvoice.Create(AOwner: TComponent; idSender,
  compilingYear, idRecipient: Integer; number: Int64; fullvendor, invoice:
  string; vendordate: TDateTime; documentType: Byte);
var
  i: Integer;
begin
  inherited Create(AOwner);

  for i := 0 to 3 do
  begin
    YearCB.Items.Add(IntToStr(YearOf(IncYear(Now, -i))));
  end;

  YearCB.ItemIndex := 0;
  DateTimePicker1.Date := Now;
  SearchDatePicker1.Date := Now;
  SearchDatePicker2.Date := Now;
  TTNDateTimePicker.Date := Now;

  Self.idSender := idSender;
  Self.compilingYear := compilingYear;
  Self.number := number;
  Self.documentType := documentType;
  Self.idRecipient := idRecipient;
  Self.Caption := '';

  case documentType of
    1:
      begin
        DateLbl.Visible := True;
        SearchGB.Enabled := False;
        SearchDatePicker1.Enabled := False;
        SearchDatePicker2.Enabled := False;
        RefreshBtn.Enabled := False;
        SetBtn.Enabled := False;
        SearchCheckBox1.Enabled := False;
        OriginalsDBGridEh.Enabled := False;
        DateTimePicker1.Visible := True;

        if Length(fullvendor) <> 0 then
        begin
          UNP.Text := Copy(fullvendor, 1, 9);
          YearCB.Text := Copy(fullvendor, 11, 4);
          NumberESCF.Text := Copy(fullvendor, 16, 10);
          DateTimePicker1.DateTime := vendordate;
          DelBtn.Visible := True;
          Self.Caption := '';
        end;
      end;
    2:
      begin
        DateLbl.Visible := False;
        TNNSearchGB.Enabled := False;
        DateTimePicker1.Visible := False;
        UNP.Text := DM.NastrPredprQUNN.AsString;

        if Length(invoice) <> 0 then
        begin
          YearCB.Text := Copy(invoice, 11, 4);
          NumberESCF.Text := Copy(invoice, 16, 10);
          Self.Caption := '';
        end;
      end;
  end;

  TTNNumber.Enabled := False;
  TTNDateTimePicker.Enabled := False;
end;

procedure TfrmAddVendorInvoice.CheckUnnBtnClick(Sender: TObject);
begin
  if Length(UNP.Text) = 0 then
  begin
    MessageDlg('   ', mtError, [mbOK], 0);
    Exit;
  end;

  PredprSelQ.Close;
  PredprSelQ.Parameters.ParamByName('UNP').Value := UNP.Text;
  PredprSelQ.Open;

  if PredprSelQ.IsEmpty then
    CheckUNNPredprNameLbl.Caption := '  '
  else
    CheckUNNPredprNameLbl.Caption := PredprSelQ.FieldByName('namePredpr').AsString;
end;

//     
procedure TfrmAddVendorInvoice.UpdateVendorProc(Table: string; Del: Boolean);
begin
  with UpdateVendor do
  begin
    SQL[1] := Table;

    if Table = 'invoices' then
      SQL[2] := 'SET vendorId=:id, vendorYear=:vYear, vendorNumber=:vnumber, vendorDate=:Date'
    else
    begin
      SQL[2] := 'SET vendorId=:id, vendorYear=:vYear, vendorNumber=:vnumber, vendorDate=:Date, vUNP=:UNP';

      if not Del then
        Parameters.ParamByName('UNP').Value := UNP.Text
      else
        Parameters.ParamByName('UNP').Value := Null;
    end;

    Parameters.ParamByName('Sender').Value := Self.idSender;
    Parameters.ParamByName('Year').Value := Self.compilingYear;
    Parameters.ParamByName('number').Value := Self.number;

    if not Del then
    begin
      Parameters.ParamByName('id').Value := PredprSelQ.FieldByName('idPredpr').Text;
      Parameters.ParamByName('vYear').Value := YearCB.Text;
      Parameters.ParamByName('vnumber').Value := NumberESCF.Text;
      Parameters.ParamByName('Date').Value := FormatDateTime('dd.mm.yyyy', DateTimePicker1.Date);
    end
    else
    begin
      Parameters.ParamByName('id').Value := Null;
      Parameters.ParamByName('vYear').Value := Null;
      Parameters.ParamByName('vnumber').Value := Null;
      Parameters.ParamByName('Date').Value := Null;
    end;

    ExecSQL;
  end;
end;

//     
procedure TfrmAddVendorInvoice.UpdateInvoiceProc(Table: string);
begin
  with UpdateInvoice do
  begin
    SQL[1] := Table;
    Parameters.ParamByName('Sender').Value := Self.idSender;
    Parameters.ParamByName('Year').Value := Self.compilingYear;
    Parameters.ParamByName('number').Value := Self.number;
    Parameters.ParamByName('invoice').Value := UNP.Text + '-' + YearCB.Text + '-' + NumberESCF.Text;
    ExecSQL;
  end;
end;

procedure TfrmAddVendorInvoice.SaveBtnClick(Sender: TObject);
begin
  if Length(UNP.Text) <> 9 then
  begin
    MessageDlg('    9 ', mtError, [mbOK], 0);
    Exit;
  end;

  if Length(NumberESCF.Text) <> 10 then
  begin
    MessageDlg('    10 ', mtError, [mbOK], 0);
    Exit;
  end;

  case Self.documentType of
    1:
      begin
        PredprSelQ.Close;
        PredprSelQ.Parameters.ParamByName('UNP').Value := UNP.Text;
        PredprSelQ.Open;

        if PredprSelQ.IsEmpty then
        begin
          MessageDlg('      ', mtError, [mbOK], 0);
          Exit;
        end;

        UpdateVendorProc('invoices', False);
        UpdateVendorProc('#invoicesout', False);
      end;
    2:
      begin
        UpdateInvoiceProc('invoices');
        UpdateInvoiceProc('#invoicesout');
      end;
  end;

  ModalResult := mrOk;
end;

procedure TfrmAddVendorInvoice.DelBtnClick(Sender: TObject);
begin
  UpdateVendorProc('invoices', True);
  UpdateVendorProc('#invoicesout', True);
end;

procedure TfrmAddVendorInvoice.RefreshBtnClick(Sender: TObject);
begin
  with SearchOriginal do
  begin
    Close;
    if SearchCheckBox1.Checked then
    begin
      if Length(Trim(TTNNumber.Text)) = 0 then
      begin
        MessageDlg('  ', mtError, [mbOK], 0);
        Exit;
      end;

      SQL[6] :=
        'WHERE doc.DocDate=:Date and doc.docNumber=:docNumb and inv.documentType=1 and inv.idRecipient=:idRec';
      Parameters.ParamByName('Date').Value := FormatDateTime('dd.mm.yyyy', TTNDateTimePicker.Date);
      Parameters.ParamByName('docNumb').Value := TTNNumber.Text;
    end
    else
    begin
      SQL[6] :=
        'WHERE doc.DocDate BETWEEN :First and :Second and inv.documentType=1 and inv.idRecipient=:idRec';
      Parameters.ParamByName('First').Value := FormatDateTime('dd.mm.yyyy', SearchDatePicker1.Date);
      Parameters.ParamByName('Second').Value := FormatDateTime('dd.mm.yyyy', SearchDatePicker2.Date);
    end;

    Parameters.ParamByName('idRec').Value := Self.idRecipient;
    Open;
  end;
end;

procedure TfrmAddVendorInvoice.SearchCheckBox1Click(Sender: TObject);
begin
  TNNSearchGB.Enabled := SearchCheckBox1.Checked;
  TTNNumber.Enabled := SearchCheckBox1.Checked;
  TTNDateTimePicker.Enabled := SearchCheckBox1.Checked;
end;

procedure TfrmAddVendorInvoice.SetBtnClick(Sender: TObject);
begin
  NumberESCF.Text := SearchOriginalnumber.AsString;
end;

end.

